/* sinus.c  aller einfachstes TekPlot-Beispiel */

#include <stdio.h>
#include <math.h>
#ifdef WINDOWS
#include <wintekplot1.h>
#else
#include <xtekplot1.h>
#endif

int main(int argc,char *argv[])
{
 double xmin=0, ymin= -1.1, xmax=10, ymax=1.1, x,y,dx;
 setmenu(AUTOMENU);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 waitTOF();//Warten auf Bildaufbau (wegen Timingproblem in X11)
 plot(xmin,sin(xmin),PENUP);
 dx=(xmax-xmin)/1000.;
 for(x=xmin+dx;x<=xmax;x+=dx)
   {y=sin(x);
    plot(x,y,PENDOWN);
   }
 term_refresh(); /* Zeichnen beenden */
 automenu_loop(); /* auf Benutzereingaben warten (z.B. Menu-Exit) */
 term_exit(); /* Grafikfenster schliessen */
}
