/* wintekplot1.cc  Tekplot fuer Windows, letzte Aenderung: 29.11.07
Autor: Rolf Pfister
Copyright: Opensource Freeware
*/
char *tekplot_version="Version 0.2";
char *tekplot_fenstername="WinTekplot Version 0.2";
/*
14.11.2007    Erstellung, Provisorische Variante

*/

#include <windows.h>
#include <stdio.h>
#define COMPILINGTEKPLOT
#include "wintekplot1.h"

static int debug=0;
#define DEBUG(n,x) if(debug>=(n)) x

/**** Globale Variablen ****/
//tekplot_version und tekplot_fenstername schon weiter oben definiert.
int tekplot_breite,tekplot_hoehe,tekplot_tiefe;
int tek_mausx=0,tek_mausy=0,maustasten_zustand=0;
FILE *tekplot_fpbild=NULL;
const int SCXRAND=22,SCYRAND=48;//provi.

class Tekplot
{
 double xmin,ymin,xmax,ymax,xs,ys,dx,dy;//fuer User-Koordinaten
 int breite,hoehe;//Fenstergroesse (Bereich in dem man zeichnen kann)
 int menubalkenhoehe;
 HPEN hpen,althpen;
 int visualklasse,aktuellefarbe;
 HMENU hMenu;
 funkzeiger menu_funkfeld[MAXMENU],menu_sub_funkfeld[MAXMENU];
 int menu_debug,menu_anzahl,menu_i,menu_isub,menu_k,j1i_max;
 int menu_istsub[MAXMENU],menu_sub_ifu[MAXMENU];
 char *menu_textfeld[MAXMENU];
 int greinflag,greinx,greiny;//fuer tek_grein()
 int fadenflag,fadenx,fadeny;//fuer Fadenkreuz
 void menu_setzen();
 void menu_reset();
 int menuvorhanden();
 void neuefenstergroesse();
public:
 int initalflag,hintergrundflag;
 HINSTANCE hInstance;
 int       iCmdShow;
 HWND      hWnd;
 MSG       msg;
 WNDCLASSEX wndclassex;
 HDC       hdc;
 PAINTSTRUCT ps;
 int exitflag;
 int scxrand, /* 2*Screenrandbreite */
     scyrand; /* Geraeteabhaengig ! (nicht verwechseln mit border) */
 Tekplot()
  {initalflag=exitflag=hintergrundflag=0;
   tekplot_breite=breite=1220; tekplot_hoehe=hoehe=680;//provi.
   tekplot_tiefe=24; //??
   tek_mausx=tek_mausy=0;
   maustasten_zustand=0;
   menubalkenhoehe=0;
   scxrand=SCXRAND; scyrand=SCYRAND;
   visualklasse=TRUECOLOR; //??
   aktuellefarbe=0;
   menu_anzahl=menu_i=menu_debug=menu_isub=menu_k=0;
   greinflag=fadenflag=0; fadenx=fadeny=0;
  }
 void inital(double xmi,double ymi,double xma,double yma);
 void inital_new(double xmi,double ymi,double xma,double yma);
 void term_refresh();
 void term_exit();
 void plot(double x,double y,int pen);
 void koordpix2user(int i,int j,double* x,double* y);
 void qkoorduser2pix(double x,double y,int *i,int *j);
 void koorduser2pix(double x,double y,int *i,int *j);
 void deltakoorduser2pix(double x,double y,int *i,int *j);
 void deltakoordpix2user(int i,int j,double *x,double *y);
 int waitmenu(int waitflag);
 void bildrefresh();
 void rgbcolor(int r,int g,int b);
 void tek_grein(double*px,double*py);
 int janeinrequester(char *text,char *jatext,char *neintext);
 void getsize(int*br,int*ho,int*ti,int*v);
 void setsize(int br,int ho,int ti);
 void setmenu(int n,...);
 //void setmenu_test(int n,...);//test
 void menu_aufruf(int id);
 void ipunkt(int ix,int iy); //noch nicht getestet
 void punkt(double x,double y); //noch nicht getestet
 void mausklick(long wParam,int ix,int iy);
 void mausklickgeloest(long wParam,int ix,int iy);
 void mausmove(long wParam,int ix,int iy);
};
static Tekplot haupt;//Haupt-Tekplotfenster

//Schnittstelle fuer C-Aufrufe:
void term() {haupt.term_refresh();}
void term_refresh() {haupt.term_refresh();}
void term_exit() {haupt.term_exit();}
void inital(double xmi,double ymi,double xma,double yma)
  {haupt.inital(xmi,ymi,xma,yma);}
void inital_new(double xmi,double ymi,double xma,double yma)
  {haupt.inital_new(xmi,ymi,xma,yma);}
int waitmenu(int waitflag) {return haupt.waitmenu(waitflag);}
void plot(double x,double y,int pen) {haupt.plot(x,y,pen);}
void ipunkt(int ix,int iy) {haupt.ipunkt(ix,iy);}
void punkt(double x,double y) {haupt.punkt(x,y);}

const int MAXPU=1000;//maximale refresh-Punkte
class Punktliste //fuer provisorischen refresh
{
 int xf[MAXPU],yf[MAXPU],penf[MAXPU],farbe[MAXPU];
 Punktliste *next;
public:
 int max;
 Punktliste() {next=NULL; max=0;}
 ~Punktliste() {if(next) delete[] next;}
 void clear() {if(next) {delete[] next;} max=0; next=NULL;}
 void put(int x,int y,int pen,int col);
 void nplot(HDC hdc,int n);
 void zeichnen(HDC& hdc,int aktfarbe);
};
Punktliste punktliste;

void Punktliste::put(int x,int y,int pen,int col)
{
 if(max<MAXPU)
       {xf[max]=x; yf[max]=y; penf[max]=pen; farbe[max]=col; max++;}
 else
       {Punktliste *p;
	//if(next==NULL) printf("Punktliste voll\n");//test
	if(next==NULL) next=new Punktliste[1];
	if(next==NULL) {printf("Fehler: zu wenig Speicher\n"); return;}
	for(p=next;p->next!=NULL; p=p->next) ;
	p->put(x,y,pen,col);
       }
}
void Punktliste::nplot(HDC hdc,int n)
{
 if(penf[n]==1) SetPixel(hdc,xf[n],yf[n],farbe[n]);
 else if(penf[n]==PENUP) MoveToEx(hdc,xf[n],yf[n],NULL);
 else LineTo(hdc,xf[n],yf[n]);
}
void Punktliste::zeichnen(HDC& hdc,int aktfarbe)
{
 int j,col=aktfarbe,altflag=0;
 HPEN hpen,hpen2,althpen;
 for(j=0;j<max;j++)
   {if(farbe[j]!=col && penf[j]!=1)
       {hpen=CreatePen(PS_SOLID,1,farbe[j]);
	hpen2=(HPEN)SelectObject(hdc,hpen);
	if(altflag==0) {althpen=hpen2; altflag=1;}
	col=farbe[j];
       }
    nplot(hdc,j);
   }
 if(next) next->zeichnen(hdc,col);
 if(altflag) {SelectObject(hdc,althpen);}
}

bool fastgleich(double a,double b)
{
 const double d=1e-10;
 return (a>b-d && a<b+d);
}

void Tekplot::inital_new(double xmi,double ymi,double xma,double yma)
{
 DEBUG(1,printf("inital_new()\n"));//test
 if(!fastgleich(xmi,xma) && !fastgleich(ymi,yma))
   {xmin=xmi; ymin=ymi; xmax=xma; ymax=yma;}
 neuefenstergroesse();
 initalflag=1;
 // if(qsave1flag) {qsaveflag=1; bildopen(bildname);}
 punktliste.clear();
 InvalidateRect(hWnd,NULL,true);
 hdc = BeginPaint(hWnd, &ps);
}

//Koordinatenumrechnungen wie in xtekplot1:
void Tekplot::koordpix2user(int i,int j,double* x,double* y)
{
 *x = xmin + i/xs;
 *y = ymin + (hoehe-1-j-menubalkenhoehe)/ys;
}
void Tekplot::qkoorduser2pix(double x,double y,int *i,int *j)
{       //quick = ohne Ueberpruefung der Grenzen
 x=(x-xmin)*xs;
 y=(y-ymin)*ys;
 *i=(int)(x+0.5);
 *j = hoehe - 1 - (int)(y+0.5) - menubalkenhoehe;
}
void Tekplot::koorduser2pix(double x,double y,int *i,int *j)
{       //mit Ueberpruefung der Grenzen
 int z;
 x=(x-xmin)*xs;
 y=(y-ymin)*ys;
 if(x>0.) {*i=(int)(x+0.5); if(*i>=breite) *i=breite-1;}
 else	  *i=0;
 if(y>0.) {z=(int)(y+0.5); if(z>=hoehe) z=hoehe-1;}
 else	  z=0;
 *j=hoehe-1-z-menubalkenhoehe;
}
void Tekplot::deltakoorduser2pix(double x,double y,int *i,int *j)
{
 if((x*=xs)>0.) *i=(int)(x+0.5);
 else		*i=(int)(x-0.5);
 if((y*=ys)>0.) *j=(int)(y+0.5);
 else		*j=(int)(y-0.5);
}
void Tekplot::deltakoordpix2user(int i,int j,double *x,double *y)
{
 *x=i/xs;
 *y=j/ys;
}

void Tekplot::plot(double x,double y,int pen)
{
 int ix,iy;
 // static int testflag=3;//test
 // if(testflag) {--testflag; printf("plot(%lf,%lf,%d)\n",x,y,pen);}//test
 koorduser2pix(x,y,&ix,&iy);
 punktliste.put(ix,iy,pen,aktuellefarbe); //provi. Methode fuer refresh
 if(pen==PENUP) MoveToEx(hdc,ix,iy,NULL);
 else LineTo(hdc,ix,iy);
}
void Tekplot::ipunkt(int ix,int iy)
{
 punktliste.put(ix,iy,1,aktuellefarbe); //provi. Methode fuer refresh
 SetPixel(hdc,ix,iy,aktuellefarbe);
}
void Tekplot::punkt(double x,double y)
{
 int ix,iy;
 koorduser2pix(x,y,&ix,&iy);
 ipunkt(ix,iy);
}

int parameter_auswerten(char *s1,char *s2,char *argv[])
{
 int n,c;
 char *s;
 argv[0]=s1;
 // s=new char[strlen(s2)+1]; strcpy(s,s2);
 s=s2;
 for(n=1;n<80 && *s!=0;n++)
   {while(*s==' ') s++;
    if(*s==0) break;
    argv[n]=s;
    while((c= *s)!=' ' && c!=0) s++;
    *s++ =0;
   }
 return n;
}

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
static TCHAR const szAppName[] = TEXT("Klassenname");

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   PSTR szCmdLine, int iCmdShow)
{
  //printf("szCmdLine='%s' iCmdShow=%d\n",szCmdLine,iCmdShow);//test
 haupt.hInstance=hInstance;
 haupt.iCmdShow=iCmdShow;
 haupt.wndclassex.cbSize        = sizeof (WNDCLASSEX);
 haupt.wndclassex.style         = CS_HREDRAW | CS_VREDRAW;
 haupt.wndclassex.lpfnWndProc   = &WndProc;
 haupt.wndclassex.cbClsExtra    = 0;
 haupt.wndclassex.cbWndExtra    = 0;
 haupt.wndclassex.hInstance     = hInstance;
 haupt.wndclassex.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
 haupt.wndclassex.hCursor       = LoadCursor(NULL, IDC_ARROW);
 haupt.wndclassex.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
 haupt.wndclassex.lpszMenuName  = NULL;
 haupt.wndclassex.lpszClassName = szAppName;
 haupt.wndclassex.hIconSm       = haupt.wndclassex.hIcon;
 
 if (!RegisterClassEx(&haupt.wndclassex))
   {
      MessageBox(NULL, TEXT("RegisterClassEx fehlgeschlagen!"),
                 szAppName, MB_OK | MB_ICONERROR);
      return -1;
   }

 // main_program(1,&szCmdLine);
 char *argv[80];
 int n=parameter_auswerten("wintekplot1",szCmdLine,argv);//provi.
 main_program(n,argv);

 UnregisterClass(szAppName, haupt.hInstance);
 return (int)haupt.msg.wParam;
}


void Tekplot::inital(double xmi,double ymi,double xma,double yma)
{
// DEBUG(1,printf("inital()\n"));//test
 xmin=xmi; ymin=ymi; xmax=xma; ymax=yma;
 if(initalflag==0)
   {initalflag=1;
    if(menuvorhanden()) menubalkenhoehe=25;//provi.
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW, // erweiterter Fensterstil
                  szAppName, // Name der Fensterklasse
                  TEXT(tekplot_fenstername), // Fenstertitel
                  WS_OVERLAPPEDWINDOW, // Fensterstil
                  CW_USEDEFAULT, // X-Position des Fensters
                  CW_USEDEFAULT, // Y-Position des Fensters
                  breite+scxrand, // Fensterbreite inklusive Raender
                  hoehe+scyrand+menubalkenhoehe, //Hoehe inkl. Menu u. Raender
                  NULL, // uebergeordnetes Fenster
                  NULL, // Menu
                  hInstance, // Programm-Kopiezaehler (Programm-ID)
                  NULL); // zusaetzliche Parameter
    ShowWindow(hWnd, iCmdShow);
    UpdateWindow(hWnd);
    menu_setzen();
   }
 else
   {printf("Warnung in inital(): initalflag schon gesetzt.\n");
   }
 neuefenstergroesse();
 // if(qsave1flag) {qsaveflag=1; bildopen(bildname);}
 punktliste.clear();
 InvalidateRect(hWnd,NULL,true);
 hdc = BeginPaint(hWnd, &ps);
}

void Tekplot::term_refresh()
{
// DEBUG(1,printf("term_refresh()\n"));//test
 EndPaint(hWnd, &ps);
 initalflag=0;
}
void Tekplot::term_exit()
{
 if(initalflag)
   {EndPaint(hWnd, &ps); initalflag=0;}
}

int Tekplot::waitmenu(int waitflag)
{
 int ret = GetMessage(&msg, NULL, 0, 0);
 if (ret == -1) return 1;
 else if (ret == 0) return 0;
 TranslateMessage(&msg);
 DispatchMessage(&msg);
 if(exitflag==1) return 1;
 return 0;
}

// Die Hauptnachrichtenschleife 
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
 HMENU hMenu;
 int n;
 switch (message)
  {
   case WM_CREATE:
       return 0;
   case WM_PAINT:
       //printf("WM_PAINT\n");//test
       haupt.bildrefresh();
       return 0;
   case WM_CLOSE:
       DestroyWindow(hWnd);
       break;
   case WM_DESTROY:
       PostQuitMessage(0);
       haupt.exitflag=1;
       return 0;
   case WM_COMMAND:
       hMenu=GetMenu(hWnd);
       //printf("WM_COMMAND: wParam=%d\n",wParam);//test
       haupt.menu_aufruf(wParam);
       break;
   case WM_LBUTTONDOWN:
       haupt.mausklick(wParam,LOWORD(lParam),HIWORD(lParam));
       break;
   case WM_MOUSEMOVE:
       haupt.mausmove(wParam,LOWORD(lParam),HIWORD(lParam));
       return 0;
   case WM_LBUTTONUP:
       haupt.mausklickgeloest(wParam,LOWORD(lParam),HIWORD(lParam));
       break;
   default:
       //printf("switch(message=%d)\n",message);//test
       break;
  }
 return DefWindowProc(hWnd, message, wParam, lParam);
}

void Tekplot::mausklick(long wParam,int ix,int iy)
{
 //printf("wParam=%d\n",wParam);//test
 if(greinflag)
   {greinx=ix; greiny=iy; fadenflag=0; fadenx=fadeny=0;}
 else DEBUG(1,printf("mausklick(%ld,%d,%d)\n",wParam,ix,iy));//test
}
void Tekplot::mausklickgeloest(long wParam,int ix,int iy)
{
 //printf("wParam=%d\n",wParam);//test
 if(greinflag)
   {greinflag=0; InvalidateRect(hWnd,NULL,true);}
 //else printf("mausklickgeloest(%ld,%d,%d)\n",wParam,ix,iy);//test
}
void Tekplot::mausmove(long wParam,int ix,int iy)
{
 if(greinflag || fadenflag)
   {if(fadenflag) {fadenx=ix; fadeny=iy;}
    else greinflag=0;
    InvalidateRect(hWnd,NULL,true);
   }
}

void Tekplot::neuefenstergroesse()
{
 RECT rect;
 GetClientRect(hWnd,&rect);
 tekplot_breite=breite=rect.right-rect.left;
 tekplot_hoehe=hoehe=rect.bottom-rect.top;
 xs = (breite-1)/(xmax-xmin); dx=1.0/xs;
 ys = (hoehe-1)/(ymax-ymin); dy=1.0/ys;
 menubalkenhoehe=0;
}
void Tekplot::bildrefresh()
{
 neuefenstergroesse();
 //printf("bildrefresh() initalflag=%d\n",initalflag);//test
 if(initalflag==0)
   {hdc=BeginPaint(hWnd,&ps);
    punktliste.zeichnen(hdc,aktuellefarbe);
    if(greinflag)
      {rgbcolor(0x80,0x80,0x80);
       MoveToEx(hdc,fadenx,0,NULL); LineTo(hdc,fadenx,hoehe-1);
       MoveToEx(hdc,0,fadeny,NULL); LineTo(hdc,breite-1,fadeny);
      }
    EndPaint(hWnd,&ps);
   }
}

void Tekplot::rgbcolor(int r,int g,int b)
{
 int bgr=(b<<16)+(g<<8)+r;
 hpen=CreatePen(PS_SOLID,1,bgr);
 althpen=(HPEN)SelectObject(hdc,hpen);
 //altefarbe=aktuellefarbe;
 aktuellefarbe=bgr;
}

int Tekplot::janeinrequester(char *text,char *jatext,char *neintext)
{
 //printf("%s\n",text);//provi.
 int knopf,n;
 if(neintext==NULL) knopf=MB_OK;
 else
   {if((n=neintext[0])=='n' || n=='N') knopf=MB_YESNO;
    else knopf=MB_OKCANCEL;
   }
 MessageBox(NULL,text,"janeinrequester",knopf);
}
void Tekplot::tek_grein(double*px,double*py)
{
 greinflag=fadenflag=1;
 while(greinflag==1) waitmenu(0);
 koordpix2user(greinx,greiny,px,py);
}

void rgbcolor(int r,int g,int b) {haupt.rgbcolor(r,g,b);}
void waitTOF(){}
void tek_grein(double*px,double*py) {haupt.tek_grein(px,py);}
int janeinrequester(char *text,char *jatext,char *neintext)
  {return haupt.janeinrequester(text,jatext,neintext);}

void getmaxsize(int*br,int*ho,int*ti,int*vis)
{
 *br=GetSystemMetrics(SM_CXSCREEN)-SCXRAND;
 *ho=GetSystemMetrics(SM_CYSCREEN)-SCYRAND;
 *ti=24; //??
 *vis=TRUECOLOR; //??
}
void Tekplot::getsize(int*br,int*ho,int*ti,int*v)
{
 *br=breite; *ho=hoehe; *ti=tekplot_tiefe; *v=visualklasse;
}
void Tekplot::setsize(int br,int ho,int dep)
{
 if(dep>32000) {dep-=32000; hintergrundflag=1;} else hintergrundflag=0;
 if(dep>1000) {debug=dep/1000; dep=dep%1000;}
 tekplot_breite=breite=br;
 tekplot_hoehe=hoehe=ho;
 tekplot_tiefe=dep;
 DEBUG(1,printf("setsize() --> breite=%d hoehe=%d tiefe=%d\n",br,ho,dep));
}
void setsize(int br,int ho,int ti) {haupt.setsize(br,ho,ti);}
void getsize(int*br,int*ho,int*ti,int*v) {haupt.getsize(br,ho,ti,v);}

void setmenu(int n,...)
{
 va_list ap;
 int i;
 const int M=8;
 char *s[M];
 funkzeiger f[M];
 va_start(ap,n);
 if(n>M) printf("vorlaeufig nur %d Menus erlaubt.\n",M);
 if(n>=1 && n<=M)
   {for(i=0;i<n;i++) s[i]=va_arg(ap,char*);
    for(i=0;i<n;i++) f[i]=va_arg(ap,funkzeiger);
   }
 switch(n)
   {case 1: haupt.setmenu(n,s[0],f[0]); break;
    case 2: haupt.setmenu(n,s[0],s[1],f[0],f[1]); break;
    case 3: haupt.setmenu(n,s[0],s[1],s[2],f[0],f[1],f[2]); break;
    case 4: haupt.setmenu(n,s[0],s[1],s[2],s[3],f[0],f[1],f[2],f[3]); break;
    case 5: haupt.setmenu(n,s[0],s[1],s[2],s[3],s[4],f[0],f[1],f[2],f[3],f[4]);
	    break;
    case 6: haupt.setmenu(n,s[0],s[1],s[2],s[3],s[4],s[5],
			    f[0],f[1],f[2],f[3],f[4],f[5]); break;
    case 7: haupt.setmenu(n,s[0],s[1],s[2],s[3],s[4],s[5],s[6],
			    f[0],f[1],f[2],f[3],f[4],f[5],f[6]); break;
    case 8: haupt.setmenu(n,s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7],
			    f[0],f[1],f[2],f[3],f[4],f[5],f[6],f[7]); break;
    default: haupt.setmenu(n);
   }
 va_end(ap);
}

/******************************* Menus ***********************************/
#include <stdarg.h>

#ifdef AUTOMENU
void automenu_exit() {haupt.exitflag=1;}
void automenu_loop()
{
 if(haupt.initalflag) term_refresh();
 while(haupt.exitflag==0 && haupt.waitmenu(1)==0) ;
 haupt.exitflag=0;
}
#endif

/* Diese Variablen sind jetzt in der Tekplot-Klasse:
static funkzeiger menu_funkfeld[MAXMENU],menu_sub_funkfeld[MAXMENU];
int		menu_debug=0;
static int	menu_anzahl=0,menu_i=0,menu_isub=0,menu_k=0,
		menu_istsub[MAXMENU],menu_sub_ifu[MAXMENU];
static char	*menu_textfeld[MAXMENU];
*/

void Tekplot::menu_reset()
  {menu_anzahl=menu_i=menu_isub=menu_k=0; menubalkenhoehe=0;}
int Tekplot::menuvorhanden() {return menu_anzahl>0;}

/*** test
void Tekplot::setmenu_test(int n,...)
{
 va_list ap;
 va_start(ap,n);
   {int i,k;
    for(k=menu_i,i=0;i<n;i++)
           {menu_textfeld[k++]=va_arg(ap,char*);
            printf("menu_textfeld[%d]='%s'\n",k-1,menu_textfeld[k-1]);//test
	   }
    for(k=menu_i-menu_isub,i=0;i<n;i++)
           {menu_funkfeld[k++]=va_arg(ap,funkzeiger);
	    printf("menu_funkfeld[%d]=0x%08X\n",k-1,menu_funkfeld[k-1]);//test
	   }
    for(i=n;i<menu_anzahl;i++)
	   {menu_textfeld[menu_i+i]=NULL; menu_funkfeld[k++]=NULL;}
    menu_i += menu_anzahl;
    if(menu_sub_ifu[menu_k]) menu_k++;
   }
 va_end(ap);
}
void setmenu_test(int n,...) //char *t1,char *t2,funkzeiger f1,funkzeiger f2)
{
 va_list ap;
 char *t1,*t2;
 funkzeiger f1,f2;
 va_start(ap,n);
 t1=va_arg(ap,char*);
 if(n==1) {
   f1=va_arg(ap,funkzeiger);
   haupt.setmenu_test(n,t1,f1);
 }
 else if(n==2) {
   t2=va_arg(ap,char*);
   f1=va_arg(ap,funkzeiger);
   f2=va_arg(ap,funkzeiger);
   haupt.setmenu_test(n,t1,t2,f1,f2);
 }
 else printf("setmenu_test geht nur mit n=1 oder n=2\n");
 va_end(ap);
}
***/

void Tekplot::setmenu(int n,...)
{
/* Beispiel:
/* setmenu(3,"File","Funktionen",     "Hilfe");	/* Menuleiste */
/* setmenu(3,"Quit","erste Funktion", "Über",   /* Menupunkte */
/*	      &quit, &erste,	      &ueber);  /* Zeiger auf Funktionen */
/* setmenu(2,"Exit","zweite Funktion",&exit,&zweite); */
/* setmenu(2,NULL,  "dritte Funktion",NULL,&dritte);  */
 va_list ap;
 int i,k;
 if(n<=0)
   {
#ifdef AUTOMENU
    if(n==AUTOMENU)
      {setmenu(1,"File"); setmenu(1,"Exit",automenu_exit);}
    else
#endif
      printf("XMENU: menu_debug=%d\n",menu_debug= -n);
    return;
   }
 if(menu_i+n > MAXMENU)
    {printf("maximale Menu-Anzahl ueberschritten\n"); return;}
 va_start(ap,n);
 if(menu_i==0)
        {menu_anzahl=n;
	 if(menu_debug) printf("menu_anzahl=%d\n",menu_anzahl);//test
	 for(i=0;i<MAXMENU;i++) menu_istsub[i]=menu_sub_ifu[i]=0;
	 menu_isub=0; menu_k=0;
	 for(i=0;i<n;i++) menu_textfeld[menu_i++]=va_arg(ap,char*);
	}
 else
        {if(menu_debug) printf("menu_i=%d\n",menu_i);//test
         for(k=menu_i,i=0;i<n;i++)
	   menu_textfeld[k++]=va_arg(ap,char*);
	 for(k=menu_i-menu_isub,i=0;i<n;i++)
	   {menu_funkfeld[k++]=va_arg(ap,funkzeiger);
//provisorisch auskommentiert		 amigatast.put(k-1,-k);
	   //printf("menu_funkfeld[%d]=0x%08X\n",k-1,menu_funkfeld[k-1]);//test
	   }
	 for(i=n;i<menu_anzahl;i++)
	   {menu_textfeld[menu_i+i]=NULL; menu_funkfeld[k++]=NULL;}
	 menu_i += menu_anzahl;
	 if(menu_sub_ifu[menu_k]) menu_k++;
	}
 va_end(ap);
}

void Tekplot::menu_setzen()
{
 HMENU hMenuPopup[menu_anzahl];
 int i,j,j1,j1i,nreihen,id,k,subnr;
 j1i_max=0;
 if(menu_i==0) return;
 hMenu=CreateMenu();
 nreihen=(menu_i-menu_isub)/menu_anzahl;
 for(i=0;i<menu_anzahl;i++)
   {hMenuPopup[i]=CreateMenu();
    AppendMenu(hMenu,MF_POPUP,(UINT_PTR)hMenuPopup[i],menu_textfeld[i]);
    for(j1=1,j=1,subnr=i,k=0; j<nreihen; j++,j1++)
        {//ji=i+j*menu_anzahl;
	 j1i=i+j1*menu_anzahl;
	 if(menu_textfeld[j1i]==NULL) break;
	 id=40000+j1i;
	 if(j1i>j1i_max) j1i_max=j1i;
	 AppendMenu(hMenuPopup[i],MF_STRING,id,menu_textfeld[j1i]);
	}
   }
 SetMenu(hWnd,hMenu);
}
void Tekplot::menu_aufruf(int id)
{
 funkzeiger funk;
 int j=id-40000;
 //printf("menu_aufruf(%d) j=%d\n",id,j);//test
 if(j>=menu_anzahl && j<=j1i_max)
   {funk=menu_funkfeld[j];
     //printf("funk=0x%08X\n",funk);//test
    if(funk!=NULL) (*funk)(j);
   }
}
