;* Genaue Uhr mit Timer1          letzte Aenderung: 7.9.2010
;* Controller: ATmega8, ATmega32
;* Copyright: Freeware
;-----------------------------------------------------------------------------
; minimales Hauptprogramm:
;.include "m8def.inc"		
.include "m32Adef.inc"
	rjmp main
.org OC1Aaddr
	rjmp timer1_match_A

;-----------------------------------------------------------------------------
; Registerbelegungen:
; r11:r10 Millisekunden, r12 Sekunden, r13 Minuten, r14 Stunden, r15 Tage
.def millisecH=r11
.def millisecL=r10
.def sec=r12
.def min=r13
.def stunden=r14
.def tage=r15

;-----------------------------------------------------------------------------
; Hochgenaue Variante mit Timer1:
; Laeuft mit beliebiger Anzahl MHz sehr genau.

; Quarz moeglichst genau ausmessen und hier eintragen
; in Hertz und Tausendstel Hertz:
.equ F_CPU=8000000		; exakt 8 MHz
.equ MilliHz=0			; Nachkommastellen

;//Ausmessung-Beispiel: 3.6864MHz ist nach 20 Stunden 0.35 sec nachgegangen:
;// 3686400 / (3600*20) * 0.35 = 17.92  3686400-17.92=3686382.080
;.equ F_CPU=3686382
;.equ MilliHz=80

.equ Rest1 = F_CPU-F_CPU/1000*1000 ;//jede Sekunde zu korrigierender Fehler
.equ Rest2 = MilliHz*6/100	   ;//jede Minute
.equ Rest3 = ((MilliHz*6-Rest2*100)*60+50)/100 ;//jede Stunde
.equ NormalerCompwert = F_CPU/1000-1

timer1_init:
	push r16
	push r17
	ldi r16, (1<<WGM12)|(1<<CS10)	;CTC-OCR1A-Modus, Prescaler=1
	out TCCR1B, r16
	ldi r16, low(NormalerCompwert)
	ldi r17, high(Normalercompwert)
	out OCR1AH, r17
	out OCR1AL, r16
	ldi r16, 0		;Startwert des Timers = 0
	out TCNT1H, r16
	out TCNT1L, r16
	ldi r16, 1<<OCIE1A	;Timer1 Interrupts bei Vergleichswert
	out TIMSK, r16
	clr millisecH
	clr millisecL
	clr sec
	clr min
	clr stunden
	clr tage
	pop r17
	pop r16
	ret

timer1_match_A:			;Interrupt-Routine
	push r16
	push r17
	push r18
	clr r18			;0 = normaler Compwert verwenden
	inc millisecL		;Millisekunden erhoehen
	brne tc1_L1
	inc millisecH
tc1_L1: ldi r16, low(1000)
	ldi r17, high(1000)
	cp  millisecL, r16
	cpc millisecH, r17	;1000 erreicht?
	breq tc1_sec		;ja-->
	ldi r16, low(1000-Rest1)
	ldi r17, high(1000-Rest1)
	cp  millisecL, r16
	cpc millisecH, r17	;millisec>=1000-Rest1 ?
	brcs tc1_fertig		;nein-->
	ldi r18, -1		;ja: r18 setzen
tc1_fertig:
	ldi r16, low(NormalerCompwert)
	ldi r17, high(Normalercompwert)
	sub r16, r18	;wenn r18 gesetzt: Compwert 1 mehr
	sbc r17, r18	;Trick: statt 1 addieren, -1 subtrahieren
			;damit sparen wir 1 Befehl
	out OCR1AH, r17
	out OCR1AL, r16
	pop r18
	pop r17
	pop r16
	reti
tc1_sec:			; Sekunden erhoehen
	clr millisecL
	clr millisecH
	inc sec
	ldi r17, 60
.if Rest2!=0
	ldi r16, 60-Rest2
	cp sec, r16		;sec >= 60-Rest2 ?
	brcs tc1_L3		;nein-->
	ldi r18, -1		;ja: r18 setzen
.endif
tc1_L3:	cp  sec, r17		;sec==60?
	brne tc1_fertig		;nein-->
	clr sec
	clr r18
	inc min			;Minuten erhoehen
.if Rest3!=0
	ldi r16, 60-Rest3
	cp min, r16		;min >= 60-Rest3 ?
	brcs tc1_L4		;nein-->
	ldi r18, -1		;ja: r18 setzen
.endif
tc1_L4:	cp min, r17
	brne tc1_fertig
	clr min
	clr r18
	inc stunden
	ldi r17, 24
	cp stunden, r17
	brne tc1_fertig
	clr stunden
	inc tage
	rjmp tc1_fertig

;-----------------------------------------------------------------------------
; milliwait  optimierte Variante  Wartezeit 1 bis 1000 Millisekunden
; in r11:r10 wird durch einen Timerinterrupt die aktuelle Millisekunde
; gespeichert (16Bit-Zahl von 0 bis 999).
; Die aktelle Sekunde ist in r12 (wird hier noch nicht benutzt, da nur
; bis maximal 1000ms gewartet werden soll).
milliwait1:			;Wartezeit: r16, 1 bis 255 msec
	push r17
	clr r17
	rjmp miL1
milliwait:			;Wartezeit: r17:r16 msec, 1 bis 1000
	push r17
miL1:	push r16
	push r18
	mov r18, r10
milop1:	cp  r18, r10
	breq milop1		;1. Millisekunde abwarten (0 bis 1 ms)
	add r16, r10
	adc r17, r11		;sollzeit = Wartezeit + aktuelle Millisek
	subi r16, low(1001)
	sbci r17, high(1001)	;sollzeit -= 1; sollzeit -= 1000;
	brpl milop2		;wenn sollzeit>=0 -->
	subi r16, low(-1000)	;sonst haben wir 1000 zuviel subtrahiert
	sbci r17, high(-1000)	;also wieder 1000 addieren (soll -= -1000)
milop2:	cp r16, r10
	cpc r17, r11		;auf sollzeit warten
	brne milop2
	cp r16, r10		;falls zwischen 1. u 2. cp ein Interrupt war
	brne milop2
	pop r18
	pop r16
	pop r17
	ret
	
;-----------------------------------------------------------------------------
; minimales Hauptprogramm:
main:	ldi r16, low(RAMEND)
        out SPL, r16		; Init Stackpointer L
        ldi r16, high(RAMEND)
        out SPH, r16		; Init Stackpointer H
	ldi r16, 0x0F
	out DDRB, r16		; Ausgaenge fuer LEDs
	rcall timer1_init

;	ldi r16, 0x40		;ADC0 und Referenz=AVCC (+ externem Condenser)
	ldi r16, 0xC0		;ADC0 und Referenz=2.56V, beim 328P ca 1.095V
;	ldi r16, 0x00		;ADC0 und Referenz=extern, 2.6V mit Spannungs-
				;teiler 2.2k, 2.0k realisiert.
	out ADMUX, r16
.equ	PRESCALER=6  ;fuer 8MHz
;.equ	PRESCALER=7  ;fuer 16MHz
;r16 = Prescaler+0b11001000 (ADEN+ADSC+ADIE = Enable,Einzelstart,Interrupt)
;ADIF (0x10) wird automatisch vom AD-Wandler gesetzt wenn Wandlung fertig.
;	ldi r16, (1<<ADEN)|(1<<ADSC)|(1<<ADIE) + PRESCALER
	ldi r16, (1<<ADEN)|(1<<ADSC) + PRESCALER
	out ADCSRA, r16		;Prescaler und Enable

	sei			; Interrupts einschalten

mainloop1:
	out PORTB, sec		; Laufende Sekunden auf den LEDs anzeigen
	in r16, ADCSRA
	andi r16, (1<<ADIF)	; AD fertig ?
	breq mainloop1		; nein-->
	clr r18
mainloop2:			; ja: schnell blinkende LED
	ldi r16, low(250)
	ldi r17, high(250)
	rcall milliwait
	inc r18
	out PORTB, r18		; LEDs im 1/4 sekundentakt hochzaehlen
	cpi r18, 10*4		; ca 10 Sec lang
	brne mainloop2
	rjmp mainloop1
