/* eeconvert.cc			letzte Aenderung: 5.6.2009 */
#define VERSION "Version 1.01"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Convertieren von (gepackten) Daten in eine xy-Datei

History:
16.4.2009	Erstellung (RP)
28.4.09     1.0 Erste richtig funktionierende Version
5.6.09     1.01 Entpackvariante 2 eingebaut

*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/
void packen(FILE *fp,FILE *fp2);
void entpacken(FILE *fp,FILE *fp2);
double umrechnen(int sensor,int variante,int wert);
int rueckumrechnen(int sensor,int variante,double y);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** kleinkram ***************************/
inline int idfix(double x) {return int((x>=0.) ? x+0.5 : x-0.5);} //Runden

bool hatendung(char *name,char *endung)
{
 int n1,n2;
 n1=strlen(name); n2=strlen(endung);
 if(n2>n1) return false;
 return strcmp(&name[n1-n2],endung)==0;
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("eeconvert  %s\n",VERSION);
	 printf("Anwendung: eeconvert [-Optionen] Quelle [Ziel.xy]\n");
	 printf(" Optionen: v = mit Testausdrucken\n");
	 printf("           c = Packen (quelle.xy --> ziel.raw)\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quelldatei:"); scanf("%s",quellname);}
 if(*zielname==0)  {printf("Zieldatei:"); scanf("%s",zielname);}
 if(argflag['C'] && !hatendung(quellname,".xy"))
   {printf("kann nur .xy Dateien packen\n"); return 0;}
 if(!argflag['C'] && hatendung(quellname,".xy"))
   {printf("kann nur Rohdaten entpacken\n"); return 0;}
 if(fp=fopen(quellname,"r"))
  {if(fp2=fopen(zielname,"w"))
    {if(argflag['C']) packen(fp,fp2);
     else entpacken(fp,fp2);
     fclose(fp2);
    }
   else printf("Konnte '%s' nicht erstellen\n",zielname);
   fclose(fp);
  }
 else printf("Datei '%s' nicht gefunden\n",quellname);
 return 0;
}/* ende von main */

void entpacken(FILE *fp,FILE *fp2)
{
/*
; 1 Byte DATENFORMAT
; 1 Byte SENSORTYP
; 1 Byte ANSCHLUSSVARIANTE
; 1 Byte Messperiode = Anzahl Sekunden zwischen 2 Messungen
; 2 Byte N = Anzahl Messpunkte
;Wenn DATENFORMAT==0: N*2 Byte ungepackte Daten
;sonst je nach Packvariante weniger als N*2 Bytes
;
;DATENFORMAT==1:
;       1X -> 4Bit, davon 3Bit Differenzwert (-4 ... +3)
;       01 -> 8Bit, davon 6Bit Differenzwert (-36 ... -5 und +4 ... +35)
;       00 -> 12Bit, davon 10Bit Absolutwert vorzeichenlos (0 ... 1023)
;DATENFORMAT==2:
; Wie 1 aber mit 14Bit-Absolutwerten:
;       00 -> 16Bit, davon 14Bit Absolutwert vorzeichenlos (0 ... 16383)
; Die Werte sind GradCelsius*10 (z.B. 357 bedeutet 35.7 Grad)
*/
 unsigned char format,sensor,variante,periode;
 int npunkte;//Anzahl Messpunkte
 unsigned char c1,c2,b1,b2,b3,b4,bcount=0;
 int i,wert=0,diff;
 double x=0,y=0;
 format=getc(fp); sensor=getc(fp); variante=getc(fp); periode=getc(fp);
 if(argflag['V'])
  printf("Datenformat=%d, Sensor=%d, Anschlussvariante=%d, Periode=%d\n",
	 format,sensor,variante,periode);
 c1=getc(fp); c2=getc(fp); npunkte=(c1<<8)+c2;
 if(argflag['V']) printf("npunkte=%d\n",npunkte);
 for(x=0,i=0;i<npunkte;i++,x+=periode)
 {if(format==0)
  {//ungepackt
   c1=getc(fp); c2=getc(fp);
   wert=(c1<<8)+(c2&0xFF);
  }
  else //if(format<=2)
  {if(bcount==0)
     {c1=getc(fp);
      b1=(c1>>4)&0x0F; //erstes Nibble
      b2=c1&0x0F; //zweites Nibble
      bcount=2;
     }
   if(b1&0x8)
    {diff=b1&0x7; if(diff&0x4) diff-=8;
     if(--bcount==1) b1=b2;
     wert+=diff;
    }
   else if((b1&0xC)==0x4)
    {if(bcount==1)
      {c1=getc(fp); b2=(c1>>4)&0x0F;}//2Nibble nachladen
     diff=((b1&0x3)<<4)+b2;
     if(diff&0x20) diff-=0x40+4; else diff+=4;
     if(bcount==1) b1=c1&0x0F;//zwar 2 gebraucht aber auch 2 nachgeladen
     else bcount-=2;//2Nibbles verbraucht
     wert+=diff;
    }
   else //if((b1&0xC)==0)
    {if(format==1)
      {c1=getc(fp);
       if(bcount==1) {b2=(c1>>4)&0x0F; b3=c1&0x0F;}
       else b3=(c1>>4)&0x0F;
       wert=(b1<<8)+(b2<<4)+b3;
       if(--bcount==1) b1=c1&0x0F;//noch 1Nibble uebrig
      }
     else //format==2
      {c1=getc(fp);
       if(bcount==1)
        {c2=getc(fp); b2=(c1>>4)&0x0F; b3=c1&0x0F; b4=(c2>>4)&0x0F;}
       else //bcount==2
        {b3=(c1>>4)&0x0F; b4=c1&0x0F;}
       wert=(b1<<12)+(b2<<8)+(b3<<4)+b4;
       if(bcount==1) b1=c2&0x0F;//noch 1Nibble uebrig
       else bcount=0;//kein Nibble mehr uebrig
      }
    }
  }
  if(format==2) y=wert*0.1;
  else y=umrechnen(sensor,variante,wert);
  if(argflag['V']) printf("x=%g wert=%d y=%lf\n",x,wert,y);
  fprintf(fp2,"%g %g\n",x,y);
 }
}

double umrechnen(int sensor,int variante,int wert)
{
 const double r1=2000;//2kOhm Widerstand nach AVCC, Messwiderstand nach GND
 const double wmax=1024;//Maximalwert 10-Bit-AD-Wandler + 1
 double r2,y;
 int i;
 if(sensor==222 && variante==1)
  {
   r2=r1*wert/(wmax-wert);
   if(argflag['V']) printf("r2=%lf Ohm\n",r2);//test
   /* provisorische Variante:
      1619 Ohm --> 0 Grad
      3426 Ohm --> 100 Grad
      Rest linear intrapoliert (Abweichungen etwa 2-3 Grad)
   */
   //y=100.0/(3426-1619)*(r2-1619);

   /* genauere Variante:
      Position in Tabelle suchen und
      zwischen entsprechenden 2 Werten intrapolieren
   */
   static int tabelle[]=
    {-55, 990, -50, 1040, -40, 1146, -30, 1260, -20, 1381, -10, 1510, 0, 1646, 10, 1790,
     20, 1941, 25, 2020, 30, 2100, 40, 2267, 50, 2441, 60, 2623, 70, 2812, 80, 3009,
     90, 3214, 100, 3426, 110, 3643, 120, 3855, 125, 3955, 130, 4048, 140, 4208, 150, 4323,
     0, 0
     };
   int t0,t1;
   double w0,w1;
   for(i=0;tabelle[i+5]!=0 && r2>tabelle[i+3];) i+=2;
   t0=tabelle[i]; t1=tabelle[i+2];
   w0=tabelle[i+1]; w1=tabelle[i+3];
   y=t0+(t1-t0)*(r2-w0)/(w1-w0);
  }
 else //unbekannter Sensor oder Variante
  {static int f=1;
   if(argflag['V'] && f>0)
    {printf("unbekannter Sensor oder unbekannte Anschlussvariante\n"); --f;}
   y=wert;
  }
 return y;
}
int rueckumrechnen(int sensor,int variante,double y)
{
 const double r1=2000;//2kOhm Widerstand nach AVCC, Messwiderstand nach GND
 const double wmax=1024;//Maximalwert 10-Bit-AD-Wandler + 1
 double r2;
 int wert;
 if(sensor==222 && variante==1)
  {
   /* provisorische Variante:
      1619 Ohm --> 0 Grad
      3426 Ohm --> 100 Grad
      Rest linear intrapoliert
   */
   r2=y*(3426-1619)/100.0+1619;
   if(argflag['V']) printf("r2=%lf\n",r2);//test
   wert=idfix(r2*wmax/(r1+r2));
  }
 else //unbekannter Sensor oder Variante
  {static int f=1;
   if(argflag['V'] && f>0)
    {printf("unbekannter Sensor oder unbekannte Anschlussvariante\n"); --f;}
   wert=idfix(y);
  }
 return wert;
}

static unsigned char speicher[10000];

void packen(FILE *fp,FILE *fp2)
{
/*
; 1 Byte DATENFORMAT
; 1 Byte SENSORTYP
; 1 Byte ANSCHLUSSVARIANTE
; 1 Byte Messperiode = Anzahl Sekunden zwischen 2 Messungen
; 2 Byte N = Anzahl Messpunkte
;Wenn DATENFORMAT==0: N*2 Byte ungepackte Daten
;sonst je nach Packvariante weniger als N*2 Bytes
*/
 unsigned char format=1,sensor=222,variante=1,periode=0;
 int npunkte;//Anzahl Messpunkte
 unsigned char *z,*z1,*z2;
 char nibble[4],nb=0;
 char zeile[80];
 int wert,wert0=0,diff,nw,k,c;
 double x,y,x0;
 z=speicher;
 *z++ = 1;
 *z++ = sensor;
 *z++ = 1;
 z1=z;
 *z++ = periode;//Messperiode noch ungueltig
 z2=z;
 *z++ = 0xFF;
 *z++ = 0xFF; //N noch ungueltig
 for(nw=0;getline(fp,zeile,80);nw++)
  {k=sscanf(zeile,"%lf %lf",&x,&y);
   if(k!=2) printf("Fehler bei sscanf k=%d\n",k);//test
   if(nw==1)
    {*z1=periode=int(x-x0);
     if(x0+periode!=x) printf("Rundungsfehler: x0=%lf x1=%lf\n",x0,x);//test
    }
   wert=rueckumrechnen(sensor,variante,y);
   if(argflag['V']) printf("rueckumrechnen() -> wert=%d\n",wert);
   if(format==0)
    {*z++ = (wert>>8)&0xFF; *z++ = wert&0xFF;//ungepackt
    }
   else if(format==1)
    {
/*
;       1X -> 4Bit, davon 3Bit Differenzwert (-4 ... +3)
;       01 -> 8Bit, davon 6Bit Differenzwert (-36 ... -5 und +4 ... +35)
;       00 -> 12Bit, davon 10Bit Absolutwert vorzeichenlos (0 ... 1023)
*/
     diff=wert-wert0;
     if(nw>0 && diff>= -4 && diff<=3)
         nibble[nb++] = 0x8+(diff&0x7);
     else if(nw>0 && diff>= -36 && diff<=35)
        {c = 0x40+(diff&0x3F);
	 nibble[nb++]=(c>>4);
	 nibble[nb++]=c&0xF;
	}
     else
        {nibble[nb++] = wert>>8;
	 nibble[nb++] = (wert>>4)&0xF;
	 nibble[nb++] = wert&0xF;
	}
     while(nb>=2)
      {c=(nibble[0]<<4)+nibble[1]; *z++ = c;
       nibble[0]=nibble[2]; nibble[1]=nibble[3];
       nb-=2;
      }
     wert0=wert;
     //hier ist nb==0 oder nb==1
    }
   else printf("unbekanntes Datenformat\n");
   x0=x;
  }
 if(nb==1) *z++ = nibble[0]<<4;
 *z2++ = (nw>>8)&0xFF; *z2++ = nw&0xFF;
 for(z1=speicher;z1<z;)
   {c = *z1++;
    putc(c,fp2);
   }
}
